/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.items.DisplayItem;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.scrollable.Scrollable;
import nl.odalitadevelopments.menus.scrollable.ScrollableBuilderImpl;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import nl.odalitadevelopments.menus.scrollable.ScrollableSlotPos;
import nl.odalitadevelopments.menus.utils.Pair;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractScrollable
implements Scrollable {
    protected final ScrollableBuilderImpl builder;
    protected final String id;
    protected final MenuContents contents;
    protected final int showYAxis;
    protected final int showXAxis;
    protected final int startRow;
    protected final int startColumn;
    protected final ScrollableDirection direction;
    protected int currentYAxis = 0;
    protected int currentXAxis = 0;
    protected final NavigableMap<Integer, Supplier<MenuItem>> items = new TreeMap<Integer, Supplier<MenuItem>>();
    private boolean initialized = false;

    protected AbstractScrollable(@NotNull ScrollableBuilderImpl builder) {
        this.builder = builder;
        this.id = builder.getId();
        this.contents = builder.getContents();
        this.showYAxis = builder.getShowYAxis();
        this.showXAxis = builder.getShowXAxis();
        this.startRow = builder.getStartRow();
        this.startColumn = builder.getStartColumn();
        this.direction = builder.getDirection();
    }

    protected abstract int newItemIndex();

    @NotNull
    protected abstract Pair<Integer, Integer> getStartEndIndexes();

    protected abstract int getIndexOffset(int var1, int var2, @NotNull ScrollableDirection var3);

    @NotNull
    protected abstract ScrollableSlotPos createSlotPos(int var1);

    @NotNull
    protected @NotNull Pair<@NotNull Integer, @NotNull Integer> rowColumnModifier(int row, int column) {
        return Pair.of(row, column);
    }

    @Override
    @NotNull
    public final synchronized Scrollable addItem(@NotNull @NotNull Supplier<@NotNull MenuItem> menuItemSupplier) {
        int index = this.newItemIndex();
        if (index < 0) {
            return this;
        }
        this.items.put(index, menuItemSupplier);
        if (this.initialized) {
            this.calculateSlotPosWithoutOffset(index).ifPresent(slotPos -> this.contents.set(SlotPos.of(slotPos), (MenuItem)menuItemSupplier.get()));
        }
        return this;
    }

    @Override
    public final int currentVertical() {
        return this.currentYAxis;
    }

    @Override
    public final int currentHorizontal() {
        return this.currentXAxis;
    }

    @Override
    public final boolean isFirstVertical() {
        return this.currentVertical() == 0;
    }

    @Override
    public final boolean isFirstHorizontal() {
        return this.currentHorizontal() == 0;
    }

    @Override
    public final boolean isLastVertical() {
        return this.currentVertical() == this.lastVertical();
    }

    @Override
    public final boolean isLastHorizontal() {
        return this.currentHorizontal() == this.lastHorizontal();
    }

    @Override
    @NotNull
    public final Scrollable openVertical(int newYAxis) {
        return this.open(newYAxis, ScrollableDirection.VERTICALLY);
    }

    @Override
    @NotNull
    public final Scrollable openHorizontal(int newXAxis) {
        return this.open(newXAxis, ScrollableDirection.HORIZONTALLY);
    }

    @Override
    @NotNull
    public final Scrollable nextVertical() {
        return this.openVertical(this.currentYAxis + 1);
    }

    @Override
    @NotNull
    public final Scrollable previousVertical() {
        return this.openVertical(this.currentYAxis - 1);
    }

    @Override
    @NotNull
    public final Scrollable nextHorizontal() {
        return this.openHorizontal(this.currentXAxis + 1);
    }

    @Override
    @NotNull
    public final Scrollable previousHorizontal() {
        return this.openHorizontal(this.currentXAxis - 1);
    }

    @Override
    @NotNull
    public final Scrollable next() {
        return switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollableDirection.VERTICALLY -> this.nextVertical();
            case ScrollableDirection.HORIZONTALLY -> this.nextHorizontal();
            case ScrollableDirection.ALL -> throw new UnsupportedOperationException("Next is not supported for 'all' direction.");
        };
    }

    @Override
    @NotNull
    public final Scrollable previous() {
        return switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case ScrollableDirection.VERTICALLY -> this.previousVertical();
            case ScrollableDirection.HORIZONTALLY -> this.previousHorizontal();
            case ScrollableDirection.ALL -> throw new UnsupportedOperationException("Previous is not supported for 'all' direction.");
        };
    }

    @Override
    @ApiStatus.Internal
    public final void setAxes(int xAxis, int yAxis) {
        if (this.initialized) {
            return;
        }
        this.currentXAxis = Math.max(0, Math.min(this.lastHorizontal(), xAxis));
        this.currentYAxis = Math.max(0, Math.min(this.lastVertical(), yAxis));
    }

    @Override
    @ApiStatus.Internal
    public final void setInitialized() {
        this.initialized = true;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public final Map<Integer, Supplier<MenuItem>> getPageItems() {
        if (this.initialized) {
            return Map.of();
        }
        HashMap<Integer, Supplier<MenuItem>> itemsBySlot = new HashMap<Integer, Supplier<MenuItem>>();
        Map<Integer, Supplier<MenuItem>> itemsByIndex = this.getItems();
        int axis = this.direction == ScrollableDirection.HORIZONTALLY ? this.currentXAxis : this.currentYAxis;
        for (Map.Entry<Integer, Supplier<MenuItem>> entry : itemsByIndex.entrySet()) {
            this.calculateSlotPosWithOffset(entry.getKey(), axis, this.direction).ifPresent(slot -> itemsBySlot.put((Integer)slot, (Supplier)entry.getValue()));
        }
        return itemsBySlot;
    }

    @NotNull
    protected final @NotNull Optional<@NotNull Integer> calculateSlotPosWithoutOffset(int index) {
        return this.calculateSlotPos(index, 0, this.direction, false);
    }

    @NotNull
    protected final @NotNull Optional<@NotNull Integer> calculateSlotPosWithOffset(int index, int axis, @NotNull ScrollableDirection direction) {
        return this.calculateSlotPos(index, axis, direction, true);
    }

    @NotNull
    private Scrollable open(int newAxis, @NotNull ScrollableDirection direction) {
        int lastAxis;
        if (this.direction != ScrollableDirection.ALL && this.direction != direction) {
            throw new IllegalArgumentException("Cannot open a scrollable in the wrong direction.");
        }
        int n = lastAxis = direction == ScrollableDirection.HORIZONTALLY ? this.lastHorizontal() : this.lastVertical();
        if (newAxis < 0 || newAxis > lastAxis) {
            return this;
        }
        int oldAxis = this.updateCurrentAxis(newAxis, direction);
        Map<Integer, Supplier<MenuItem>> pageItems = this.getItems();
        if (pageItems.isEmpty()) {
            this.updateCurrentAxis(oldAxis, direction);
            return this;
        }
        this.clearMenuGrid();
        for (Map.Entry<Integer, Supplier<MenuItem>> entry : pageItems.entrySet()) {
            this.calculateSlotPosWithOffset(entry.getKey(), newAxis, direction).ifPresent(slot -> this.updateItem((int)slot, (Supplier)entry.getValue()));
        }
        this.contents.cache().getPageSwitchUpdateItems().forEach((slot, item) -> this.contents.set((int)slot, (MenuItem)item.get()));
        return this;
    }

    private Map<Integer, Supplier<MenuItem>> getItems() {
        Pair<Integer, Integer> startEndIndexes = this.getStartEndIndexes();
        int startIndex = startEndIndexes.getKey();
        int endIndex = startEndIndexes.getValue();
        HashMap<Integer, Supplier<MenuItem>> items = new HashMap<Integer, Supplier<MenuItem>>(this.items.subMap(startIndex, endIndex));
        for (int i = startIndex; i < endIndex; ++i) {
            items.putIfAbsent(i, null);
        }
        return items;
    }

    @NotNull
    private @NotNull Optional<@NotNull Integer> calculateSlotPos(int index, int axis, @NotNull ScrollableDirection direction, boolean offsetPresent) {
        int offset = offsetPresent ? this.getIndexOffset(index, axis, direction) : 0;
        ScrollableSlotPos slotPos = this.createSlotPos(index - offset);
        Pair<Integer, Integer> rowColumnModifier = this.rowColumnModifier(slotPos.getRow(), slotPos.getColumn());
        int row = this.startRow + rowColumnModifier.getKey();
        int column = this.startColumn + rowColumnModifier.getValue();
        if (row < this.startRow || column < this.startColumn || row >= this.startRow + this.showYAxis || column >= this.startColumn + this.showXAxis) {
            return Optional.empty();
        }
        return Optional.of(SlotPos.of(row, column).getSlot());
    }

    private void clearMenuGrid() {
        for (int row = this.startRow; row < this.startRow + this.showYAxis; ++row) {
            for (int column = this.startColumn; column < this.startColumn + this.showXAxis; ++column) {
                this.contents.menuSession().contents[row][column] = null;
            }
        }
    }

    private void updateItem(int slot, Supplier<MenuItem> menuItemSupplier) {
        MenuItem menuItem = menuItemSupplier == null ? DisplayItem.of(new ItemStack(Material.AIR)) : menuItemSupplier.get();
        this.contents.set(slot, menuItem);
    }

    private int updateCurrentAxis(int newAxis, ScrollableDirection direction) {
        int oldAxis;
        if (direction == ScrollableDirection.VERTICALLY) {
            oldAxis = this.currentYAxis;
            this.currentYAxis = newAxis;
        } else {
            oldAxis = this.currentXAxis;
            this.currentXAxis = newAxis;
        }
        return oldAxis;
    }

    final void initItems() {
        this.builder.getItems().forEach(this::addItem);
    }
}

