/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.Comparator;
import java.util.Map;
import nl.odalitadevelopments.menus.scrollable.AbstractScrollable;
import nl.odalitadevelopments.menus.scrollable.ScrollableBuilderImpl;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirectionPatternCache;
import nl.odalitadevelopments.menus.scrollable.ScrollableSlotPos;
import nl.odalitadevelopments.menus.utils.Pair;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class PatternScrollableImpl
extends AbstractScrollable {
    private final ScrollableDirectionPatternCache.Cache patternCache;
    private int lastPatternIndex;

    PatternScrollableImpl(@NotNull ScrollableBuilderImpl builder) {
        super(builder);
        this.patternCache = builder.getPatternCache();
        this.lastPatternIndex = -1;
    }

    @Override
    public int lastVertical() {
        return this.patternCache.height() - this.showYAxis;
    }

    @Override
    public int lastHorizontal() {
        return this.patternCache.width() - this.showXAxis;
    }

    @Override
    protected int newItemIndex() {
        int index;
        Map.Entry newIndexEntry = this.patternCache.index().entrySet().stream().filter(entry -> (Integer)entry.getValue() > this.lastPatternIndex).min(Comparator.comparingInt(Map.Entry::getValue)).orElse(null);
        if (newIndexEntry == null || (index = ((Integer)newIndexEntry.getKey()).intValue()) <= -1) {
            return -1;
        }
        this.lastPatternIndex = (Integer)newIndexEntry.getValue();
        return index;
    }

    @Override
    @NotNull
    protected Pair<Integer, Integer> getStartEndIndexes() {
        int startIndex = this.createSlotPos(this.currentYAxis, this.currentXAxis).getSlot();
        int endIndex = this.createSlotPos(this.showYAxis + this.currentYAxis - 1, this.showXAxis + this.currentXAxis).getSlot();
        return Pair.of(startIndex, endIndex);
    }

    @Override
    protected int getIndexOffset(int index, int axis, @NotNull ScrollableDirection direction) {
        return 0;
    }

    @Override
    @NotNull
    protected ScrollableSlotPos createSlotPos(int index) {
        return ScrollableSlotPos.of(this.patternCache.height(), this.patternCache.width(), index);
    }

    @Override
    @NotNull
    protected @NotNull Pair<@NotNull Integer, @NotNull Integer> rowColumnModifier(int row, int column) {
        return Pair.of(row - this.currentYAxis, column - this.currentXAxis);
    }

    @NotNull
    private ScrollableSlotPos createSlotPos(int row, int column) {
        return ScrollableSlotPos.of(this.patternCache.height(), this.patternCache.width(), row, column);
    }
}

