/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.Comparator;
import java.util.Map;
import nl.odalitadevelopments.menus.scrollable.PatternScrollableImpl;
import nl.odalitadevelopments.menus.scrollable.ScrollableBuilderImpl;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirectionPatternCache;
import nl.odalitadevelopments.menus.scrollable.ScrollableSlotPos;
import nl.odalitadevelopments.menus.utils.Pair;
import org.jetbrains.annotations.NotNull;

final class RepeatedPatternScrollableImpl
extends PatternScrollableImpl {
    private final ScrollableDirectionPatternCache.Cache patternCache;
    private int lastPatternIndex = -1;
    private int lastIndex = 0;
    private int lastVertical = -1;
    private int lastHorizontal = -1;

    RepeatedPatternScrollableImpl(@NotNull ScrollableBuilderImpl builder) {
        super(builder);
        this.patternCache = builder.getPatternCache();
    }

    @Override
    public int lastVertical() {
        if (this.lastVertical == -1) {
            this.calculateLastVertical();
        }
        return this.lastVertical;
    }

    @Override
    public int lastHorizontal() {
        if (this.lastHorizontal == -1) {
            this.calculateLastHorizontal();
        }
        return this.lastHorizontal;
    }

    @Override
    protected int newItemIndex() {
        int index;
        Map.Entry newIndexEntry = this.patternCache.index().entrySet().stream().filter(entry -> (Integer)entry.getValue() > this.lastPatternIndex).min(Comparator.comparingInt(Map.Entry::getValue)).orElse(null);
        if (newIndexEntry == null) {
            newIndexEntry = this.patternCache.index().entrySet().stream().filter(entry -> (Integer)entry.getValue() > -1).min(Comparator.comparingInt(Map.Entry::getValue)).orElse(null);
            if (newIndexEntry == null) {
                return -1;
            }
            this.lastPatternIndex = -1;
            this.lastIndex += this.patternCache.height() * this.patternCache.width();
        }
        if ((index = (Integer)newIndexEntry.getKey() + this.lastIndex) <= -1) {
            return -1;
        }
        this.lastPatternIndex = (Integer)newIndexEntry.getValue();
        if (this.direction == ScrollableDirection.HORIZONTALLY && this.lastHorizontal != -1) {
            this.lastHorizontal = -1;
        } else if (this.direction == ScrollableDirection.VERTICALLY && this.lastVertical != -1) {
            this.lastVertical = -1;
        }
        return index;
    }

    @Override
    @NotNull
    protected Pair<Integer, Integer> getStartEndIndexes() {
        int startIndex = this.direction == ScrollableDirection.HORIZONTALLY ? this.currentXAxis * this.showYAxis : this.currentYAxis * this.showXAxis;
        int endIndex = this.direction == ScrollableDirection.HORIZONTALLY ? this.showYAxis * this.showXAxis + this.currentXAxis * this.showYAxis : this.showYAxis * this.showXAxis + this.currentYAxis * this.showXAxis;
        return Pair.of(startIndex, endIndex);
    }

    @Override
    protected int getIndexOffset(int index, int axis, @NotNull ScrollableDirection direction) {
        return direction == ScrollableDirection.HORIZONTALLY ? axis * this.patternCache.height() : axis * this.patternCache.width();
    }

    @Override
    @NotNull
    protected ScrollableSlotPos createSlotPos(int index) {
        return ScrollableSlotPos.of(this.direction.getCacheInitializationDirection(), this.showYAxis, this.showXAxis, index);
    }

    @Override
    @NotNull
    protected @NotNull Pair<@NotNull Integer, @NotNull Integer> rowColumnModifier(int row, int column) {
        return Pair.of(row, column);
    }

    private void calculateLastVertical() {
        LastPageData lastPageData = this.calculateLastPageData();
        int usedPatternAmount = lastPageData.usedPatternAmount();
        int offsetIndex = lastPageData.offsetIndex();
        int offset = offsetIndex == -1 ? 0 : this.createSlotPos(offsetIndex).getRow() + 1;
        this.lastVertical = Math.max(0, usedPatternAmount * this.patternCache.height() - this.showYAxis + offset);
        if (this.currentYAxis > this.lastVertical) {
            this.currentYAxis = this.lastVertical;
        }
    }

    private void calculateLastHorizontal() {
        LastPageData lastPageData = this.calculateLastPageData();
        int usedPatternAmount = lastPageData.usedPatternAmount();
        int offsetIndex = lastPageData.offsetIndex();
        int offset = offsetIndex == -1 ? 0 : this.createSlotPos(offsetIndex).getColumn() + 1;
        this.lastHorizontal = Math.max(0, usedPatternAmount * this.patternCache.width() - this.showXAxis + offset);
        if (this.currentXAxis > this.lastHorizontal) {
            this.currentXAxis = this.lastHorizontal;
        }
    }

    private LastPageData calculateLastPageData() {
        int usedPatternAmount = (int)Math.floor((double)this.items.size() / (double)this.patternCache.amountOfIndexes());
        int restItems = this.items.size() - usedPatternAmount * this.patternCache.amountOfIndexes();
        int offsetIndex = -1;
        for (Map.Entry entry : this.patternCache.index().entrySet()) {
            if ((Integer)entry.getValue() != restItems) continue;
            offsetIndex = (Integer)entry.getKey();
            break;
        }
        return new LastPageData(usedPatternAmount, offsetIndex);
    }

    record LastPageData(int usedPatternAmount, int offsetIndex) {
    }
}

