/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import nl.odalitadevelopments.menus.contents.MenuContents;
import nl.odalitadevelopments.menus.items.MenuItem;
import nl.odalitadevelopments.menus.patterns.PatternContainer;
import nl.odalitadevelopments.menus.scrollable.AbstractScrollable;
import nl.odalitadevelopments.menus.scrollable.PatternScrollableImpl;
import nl.odalitadevelopments.menus.scrollable.RepeatedPatternScrollableImpl;
import nl.odalitadevelopments.menus.scrollable.Scrollable;
import nl.odalitadevelopments.menus.scrollable.ScrollableBuilder;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirectionPattern;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirectionPatternCache;
import nl.odalitadevelopments.menus.scrollable.SingleScrollableImpl;
import org.jetbrains.annotations.NotNull;

final class ScrollableBuilderImpl
implements ScrollableBuilder {
    private final MenuContents contents;
    private final String id;
    private final int showYAxis;
    private final int showXAxis;
    private List<Supplier<MenuItem>> items = new ArrayList<Supplier<MenuItem>>();
    private int startRow;
    private int startColumn;
    private boolean isSingle;
    private ScrollableDirection direction;
    private ScrollableDirectionPatternCache.Cache patternCache;
    private boolean repeatedPattern;
    private ScrollableDirectionPatternCache tempPatternCache;

    @Override
    @NotNull
    public ScrollableBuilder items(@NotNull @NotNull List<@NotNull Supplier<@NotNull MenuItem>> items) {
        this.items = items;
        return this;
    }

    @Override
    @NotNull
    public ScrollableBuilder.ScrollableSingleBuilder single(int startRow, int startColumn) {
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.isSingle = true;
        return new ScrollableSingleBuilderImpl(this);
    }

    @Override
    @NotNull
    public ScrollableBuilder.ScrollablePatternBuilder pattern(int startRow, int startColumn, @NotNull Class<? extends ScrollableDirectionPattern> patternClass) {
        PatternContainer patternContainer = this.contents.menuSession().getInstance().getPatternContainer();
        ScrollableDirectionPatternCache patternCache = (ScrollableDirectionPatternCache)patternContainer.getPattern(patternClass);
        if (patternCache == null) {
            throw new IllegalArgumentException("No scrollable pattern found for class: '" + patternClass.getName() + "'");
        }
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.isSingle = false;
        this.tempPatternCache = patternCache;
        return new ScrollablePatternBuilderImpl(this);
    }

    @Override
    @NotNull
    public Scrollable create() {
        AbstractScrollable scrollable;
        if (this.isSingle) {
            scrollable = new SingleScrollableImpl(this);
        } else if (this.repeatedPattern) {
            this.patternCache = this.tempPatternCache.initialize(this.direction.getCacheInitializationDirection());
            scrollable = new RepeatedPatternScrollableImpl(this);
        } else {
            this.patternCache = this.tempPatternCache.initialize(this.direction.getCacheInitializationDirection());
            scrollable = new PatternScrollableImpl(this);
        }
        this.contents.menuSession().getCache().getScrollableMap().put(this.id, scrollable);
        scrollable.initItems();
        return scrollable;
    }

    public ScrollableBuilderImpl(MenuContents contents, String id, int showYAxis, int showXAxis) {
        this.contents = contents;
        this.id = id;
        this.showYAxis = showYAxis;
        this.showXAxis = showXAxis;
    }

    MenuContents getContents() {
        return this.contents;
    }

    String getId() {
        return this.id;
    }

    int getShowYAxis() {
        return this.showYAxis;
    }

    int getShowXAxis() {
        return this.showXAxis;
    }

    List<Supplier<MenuItem>> getItems() {
        return this.items;
    }

    int getStartRow() {
        return this.startRow;
    }

    int getStartColumn() {
        return this.startColumn;
    }

    boolean isSingle() {
        return this.isSingle;
    }

    ScrollableDirection getDirection() {
        return this.direction;
    }

    ScrollableDirectionPatternCache.Cache getPatternCache() {
        return this.patternCache;
    }

    boolean isRepeatedPattern() {
        return this.repeatedPattern;
    }

    public static final class ScrollableSingleBuilderImpl
    implements ScrollableBuilder.ScrollableSingleBuilder {
        private final ScrollableBuilderImpl builder;

        @Override
        @NotNull
        public Scrollable horizontally() {
            this.builder.direction = ScrollableDirection.HORIZONTALLY;
            return this.builder.create();
        }

        @Override
        @NotNull
        public Scrollable vertically() {
            this.builder.direction = ScrollableDirection.VERTICALLY;
            return this.builder.create();
        }

        public ScrollableSingleBuilderImpl(ScrollableBuilderImpl builder) {
            this.builder = builder;
        }
    }

    public static final class ScrollablePatternBuilderImpl
    implements ScrollableBuilder.ScrollablePatternBuilder {
        private final ScrollableBuilderImpl builder;

        @Override
        @NotNull
        public ScrollableBuilder.ScrollableRepeatedPatternBuilder horizontally() {
            this.builder.direction = ScrollableDirection.HORIZONTALLY;
            return new ScrollableRepeatedPatternBuilderImpl(this.builder);
        }

        @Override
        @NotNull
        public ScrollableBuilder.ScrollableRepeatedPatternBuilder vertically() {
            this.builder.direction = ScrollableDirection.VERTICALLY;
            return new ScrollableRepeatedPatternBuilderImpl(this.builder);
        }

        @Override
        @NotNull
        public Scrollable horizontallyAndVertically() {
            this.builder.direction = ScrollableDirection.ALL;
            return this.builder.create();
        }

        public ScrollablePatternBuilderImpl(ScrollableBuilderImpl builder) {
            this.builder = builder;
        }
    }

    public static final class ScrollableRepeatedPatternBuilderImpl
    implements ScrollableBuilder.ScrollableRepeatedPatternBuilder {
        private final ScrollableBuilderImpl builder;

        @Override
        @NotNull
        public Scrollable repeated() {
            this.builder.repeatedPattern = true;
            return this.builder.create();
        }

        @Override
        @NotNull
        public Scrollable once() {
            this.builder.repeatedPattern = false;
            return this.builder.create();
        }

        @Override
        @NotNull
        public Scrollable repeated(boolean repeated) {
            this.builder.repeatedPattern = repeated;
            return this.builder.create();
        }

        @Override
        @NotNull
        public Scrollable once(boolean once) {
            return this.repeated(!once);
        }

        public ScrollableRepeatedPatternBuilderImpl(ScrollableBuilderImpl builder) {
            this.builder = builder;
        }
    }
}

