/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import nl.odalitadevelopments.menus.iterators.MenuIterator;
import nl.odalitadevelopments.menus.patterns.MenuPattern;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirectionPatternCache;
import nl.odalitadevelopments.menus.utils.CharacterUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ScrollableDirectionPattern
extends MenuPattern<ScrollableDirectionPatternCache> {
    @Override
    @NotNull
    default public ScrollableDirectionPatternCache getCache() {
        ScrollableDirectionPatternCache cache = new PatternInitializer(this.getPattern()).initializeIndex();
        if (cache == null) {
            throw new IllegalStateException("Could not initialize index of pattern: '" + this.getClass().getName() + "'");
        }
        return cache;
    }

    @Override
    default public void handle(@NotNull MenuIterator menuIterator) {
    }

    public record PatternInitializer(List<String> pattern) {
        @Nullable
        private ScrollableDirectionPatternCache initializeIndex() {
            if (this.pattern.isEmpty()) {
                return null;
            }
            HashMap<ScrollableDirection, NavigableMap<Integer, Integer>> directionIndex = new HashMap<ScrollableDirection, NavigableMap<Integer, Integer>>();
            HashMap<ScrollableDirection, Integer> directionWidth = new HashMap<ScrollableDirection, Integer>();
            NavigableMap horizontalIndex = directionIndex.computeIfAbsent(ScrollableDirection.HORIZONTALLY, direction -> new TreeMap());
            NavigableMap verticalIndex = directionIndex.computeIfAbsent(ScrollableDirection.VERTICALLY, direction -> new TreeMap());
            directionWidth.computeIfAbsent(ScrollableDirection.HORIZONTALLY, direction -> this.initializeHorizontal(horizontalIndex));
            directionWidth.computeIfAbsent(ScrollableDirection.VERTICALLY, direction -> this.initializeVertical(verticalIndex));
            return new ScrollableDirectionPatternCache(this.pattern, this.pattern.size(), directionIndex, directionWidth);
        }

        private int initializeHorizontal(NavigableMap<Integer, Integer> index) {
            int currentIndex = 0;
            int width = 0;
            for (String patternLine : this.pattern) {
                String[] splitArray = patternLine.split("\\|");
                if (width == 0) {
                    width = splitArray.length;
                }
                if (splitArray.length != width) {
                    throw new IllegalStateException("Pattern line '" + patternLine + "' has a different width than the previous lines.");
                }
                for (String currentIndexValue : splitArray) {
                    currentIndex = this.handleCurrentIndexValue(index, currentIndexValue, currentIndex);
                }
            }
            return width;
        }

        private int initializeVertical(NavigableMap<Integer, Integer> index) {
            int currentIndex = 0;
            int width = this.pattern.get(0).split("\\|").length;
            for (int column = 0; column < width; ++column) {
                for (String patternLine : this.pattern) {
                    String[] splitArray = patternLine.split("\\|");
                    if (splitArray.length != width) {
                        throw new IllegalStateException("Pattern line '" + patternLine + "' has a different width than the previous lines.");
                    }
                    String currentIndexValue = splitArray[column];
                    currentIndex = this.handleCurrentIndexValue(index, currentIndexValue, currentIndex);
                }
            }
            return width;
        }

        private int handleCurrentIndexValue(NavigableMap<Integer, Integer> index, String currentIndexValue, int currentIndex) {
            if (currentIndexValue.contains("#")) {
                index.put(currentIndex++, -1);
                return currentIndex;
            }
            if (CharacterUtils.isDigits(currentIndexValue)) {
                index.put(currentIndex++, Integer.parseInt(currentIndexValue));
            }
            return currentIndex;
        }
    }
}

