/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import org.jetbrains.annotations.NotNull;

final class ScrollableDirectionPatternCache {
    private final List<String> pattern;
    private final int height;
    private final Map<ScrollableDirection, NavigableMap<Integer, Integer>> directionIndex;
    private final Map<ScrollableDirection, Integer> directionWidth;

    @NotNull
    Cache initialize(ScrollableDirection direction) {
        if (direction != ScrollableDirection.HORIZONTALLY && direction != ScrollableDirection.VERTICALLY) {
            throw new IllegalArgumentException("Direction is not supported '" + String.valueOf((Object)direction) + "'");
        }
        NavigableMap<Integer, Integer> index = this.directionIndex.get((Object)direction);
        int width = this.directionWidth.get((Object)direction);
        int amountOfIndexes = (int)index.values().stream().filter(i -> i > -1).count();
        int highestIndex = this.height * width;
        return new Cache(this.pattern, index, this.height, width, amountOfIndexes, highestIndex);
    }

    ScrollableDirectionPatternCache(List<String> pattern, int height, Map<ScrollableDirection, NavigableMap<Integer, Integer>> directionIndex, Map<ScrollableDirection, Integer> directionWidth) {
        this.pattern = pattern;
        this.height = height;
        this.directionIndex = directionIndex;
        this.directionWidth = directionWidth;
    }

    record Cache(List<String> pattern, NavigableMap<Integer, Integer> index, int height, int width, int amountOfIndexes, int highestIndex) {
    }
}

