/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.scrollable;

import nl.odalitadevelopments.menus.contents.pos.SlotPos;
import nl.odalitadevelopments.menus.contents.pos.SlotPosition;
import nl.odalitadevelopments.menus.scrollable.ScrollableDirection;
import org.jetbrains.annotations.NotNull;

class ScrollableSlotPos
extends SlotPosition {
    @NotNull
    static ScrollableSlotPos of(int height, int width, int row, int column) {
        return new ScrollableSlotPos(height, width, row, column);
    }

    @NotNull
    static ScrollableSlotPos of(@NotNull ScrollableDirection direction, int height, int width, int slot) {
        return new ScrollableSlotPos(direction, height, width, slot);
    }

    @NotNull
    static ScrollableSlotPos of(int height, int width, int slot) {
        return new ScrollableSlotPos(ScrollableDirection.HORIZONTALLY, height, width, slot);
    }

    private ScrollableSlotPos(int height, int width, int row, int column) {
        super(height, width, row, column);
    }

    private ScrollableSlotPos(ScrollableDirection direction, int height, int width, int slot) {
        super(height, width, slot);
        if (direction == ScrollableDirection.VERTICALLY) {
            this.column = slot / height;
            this.row = slot - height * this.column;
        }
    }

    static class SingleScrollableSlotPos
    extends ScrollableSlotPos {
        @NotNull
        static SingleScrollableSlotPos of(@NotNull ScrollableDirection direction, int height, int width, int slot) {
            return new SingleScrollableSlotPos(direction, height, width, slot);
        }

        private SingleScrollableSlotPos(ScrollableDirection direction, int height, int width, int slot) {
            super(direction, height, width, slot);
            if (direction == ScrollableDirection.HORIZONTALLY) {
                this.row = slot % height;
                this.column = slot / height;
            } else if (direction == ScrollableDirection.VERTICALLY) {
                this.row = slot / width;
                this.column = slot % width;
            }
            this.slot = SlotPos.of(this.row, this.column).getSlot();
        }
    }
}

