/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.tasks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import nl.odalitadevelopments.menus.OdalitaMenus;
import nl.odalitadevelopments.menus.menu.MenuProcessor;
import nl.odalitadevelopments.menus.menu.MenuSession;
import nl.odalitadevelopments.menus.nms.utils.OdalitaLogger;
import nl.odalitadevelopments.menus.tasks.MenuSchedulerTask;
import nl.odalitadevelopments.menus.tasks.MenuTaskRunnable;
import nl.odalitadevelopments.menus.tasks.MenuUpdateTask;
import org.bukkit.entity.Player;

public final class MenuTasksProcessor
implements Runnable {
    private static final AtomicInteger TICK_COUNTER = new AtomicInteger(0);
    private final Collection<MenuTaskRunnable> tasks = new HashSet<MenuTaskRunnable>();
    private final OdalitaMenus instance;
    private final MenuProcessor menuProcessor;

    public MenuTasksProcessor(OdalitaMenus instance) {
        this.instance = instance;
        this.menuProcessor = instance.getMenuProcessor();
        this.tasks.add(new MenuSchedulerTask());
        this.tasks.add(new MenuUpdateTask());
    }

    @Override
    public void run() {
        try {
            int tick = TICK_COUNTER.getAndIncrement();
            for (MenuTaskRunnable runnable : this.tasks) {
                runnable.runGlobally(this.instance, this.menuProcessor, tick);
            }
            Map<Player, MenuSession> openMenus = this.menuProcessor.getOpenMenus();
            for (Map.Entry<Player, MenuSession> entry : openMenus.entrySet()) {
                Player player;
                MenuSession menuSession = entry.getValue();
                if (menuSession == null || menuSession.isClosed() || (player = entry.getKey()) == null || !player.isOnline()) continue;
                for (MenuTaskRunnable runnable : this.tasks) {
                    runnable.runPerSession(this.instance, this.menuProcessor, tick, player, menuSession);
                }
            }
        }
        catch (Exception exception) {
            OdalitaLogger.error(exception);
        }
    }
}

