/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.utils;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitThreadHelper {
    private BukkitThreadHelper() {
    }

    public static void runSync(@NotNull JavaPlugin plugin, @NotNull Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
        }
    }

    public static void runAsync(@NotNull JavaPlugin plugin, @NotNull Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, runnable);
        } else {
            runnable.run();
        }
    }

    public static void runCondition(boolean async, @NotNull JavaPlugin plugin, @NotNull Runnable runnable) {
        if (async) {
            BukkitThreadHelper.runAsync(plugin, runnable);
        } else {
            BukkitThreadHelper.runSync(plugin, runnable);
        }
    }
}

