/*
 * Decompiled with CFR 0.152.
 */
package nl.odalitadevelopments.menus.utils.packet;

import nl.odalitadevelopments.menus.nms.OdalitaMenusNMS;
import nl.odalitadevelopments.menus.nms.packet.ClientboundSetContentsPacket;
import nl.odalitadevelopments.menus.nms.packet.ClientboundSetSlotPacket;
import nl.odalitadevelopments.menus.providers.providers.PacketListenerProvider;
import nl.odalitadevelopments.menus.utils.packet.OdalitaMenuPacket;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetContentsPacket;
import nl.odalitadevelopments.menus.utils.packet.OdalitaSetSlotPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketConverter {
    private PacketConverter() {
    }

    @Nullable
    public static OdalitaMenuPacket convertClientboundPacket(@NotNull PacketListenerProvider.ClientboundPacketType type, @NotNull Object packetObject) {
        if (type == PacketListenerProvider.ClientboundPacketType.SET_SLOT) {
            return PacketConverter.convertSetSlotPacket(packetObject);
        }
        if (type == PacketListenerProvider.ClientboundPacketType.SET_CONTENTS) {
            return PacketConverter.convertWindowItemsPacket(packetObject);
        }
        return null;
    }

    public static void updateClientboundPacket(@NotNull PacketListenerProvider.ClientboundPacketType type, @NotNull OdalitaMenuPacket packet) {
        if (type == PacketListenerProvider.ClientboundPacketType.SET_SLOT) {
            PacketConverter.updateSetSlotPacket(packet);
            return;
        }
        if (type == PacketListenerProvider.ClientboundPacketType.SET_CONTENTS) {
            PacketConverter.updateWindowItemsPacket(packet);
        }
    }

    private static OdalitaSetSlotPacket convertSetSlotPacket(@NotNull Object packetObject) {
        ClientboundSetSlotPacket packet = OdalitaMenusNMS.getInstance().readSetSlotPacket(packetObject);
        if (packet == null) {
            return null;
        }
        return new OdalitaSetSlotPacket(packet, packet.windowId(), packet.slot(), packet.item());
    }

    private static OdalitaSetContentsPacket convertWindowItemsPacket(@NotNull Object packetObject) {
        ClientboundSetContentsPacket packet = OdalitaMenusNMS.getInstance().readSetContentsPacket(packetObject);
        if (packet == null) {
            return null;
        }
        return new OdalitaSetContentsPacket(packet, packet.windowId(), packet.stateId(), packet.items(), packet.carriedItem());
    }

    private static void updateSetSlotPacket(@NotNull OdalitaMenuPacket odalitaMenuPacket) {
        if (!(odalitaMenuPacket instanceof OdalitaSetSlotPacket)) {
            return;
        }
        OdalitaSetSlotPacket packet = (OdalitaSetSlotPacket)odalitaMenuPacket;
        if (packet.origin() != null) {
            packet.origin().update();
        }
    }

    private static void updateWindowItemsPacket(@NotNull OdalitaMenuPacket odalitaMenuPacket) {
        if (!(odalitaMenuPacket instanceof OdalitaSetContentsPacket)) {
            return;
        }
        OdalitaSetContentsPacket packet = (OdalitaSetContentsPacket)odalitaMenuPacket;
        if (packet.origin() != null) {
            packet.origin().update();
        }
    }
}

